/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview;

import com.aptana.editor.common.IEditorLinkedResources;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.preview.IPreviewHandler;
import com.aptana.preview.Messages;
import com.aptana.preview.PreviewConfig;
import com.aptana.preview.PreviewEditorInput;
import com.aptana.preview.PreviewPlugin;
import com.aptana.preview.SourceConfig;
import com.aptana.preview.internal.DefaultPreviewHandler;
import com.aptana.preview.internal.EditorUtils;
import com.aptana.preview.internal.PreviewHandlers;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.contentobjects.jnotify.JNotifyAdapter;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class PreviewManager {
    private static PreviewManager instance;
    private IPropertyListener editorPropertyListener;
    private Map<IEditorPart, PreviewEditorInput> trackedEditors = new WeakHashMap<IEditorPart, PreviewEditorInput>();
    private Map<IEditorPart, Integer> filewatchIds = new HashMap<IEditorPart, Integer>();
    private Set<URI> trackedURIs = new HashSet<URI>();
    private IPartListener editorPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                part.removePropertyListener(PreviewManager.this.editorPropertyListener);
                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                if (editorInput instanceof IURIEditorInput) {
                    PreviewManager.this.trackedURIs.remove(((IURIEditorInput)editorInput).getURI());
                }
            }
            if (PreviewManager.this.trackedEditors.containsKey(part)) {
                PreviewManager.this.trackedEditors.remove(part);
                PreviewManager.this.removeFilewatchListener((IEditorPart)part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                part.addPropertyListener(PreviewManager.this.editorPropertyListener);
                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                if (editorInput instanceof IURIEditorInput) {
                    PreviewManager.this.trackedURIs.add(((IURIEditorInput)editorInput).getURI());
                }
            }
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(PreviewManager.this.editorPartListener);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(PreviewManager.this.editorPartListener);
            }
        }
    };

    private PreviewManager() {
        this.editorPropertyListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (source instanceof IEditorPart && 257 == propId && !((EditorPart)source).isDirty()) {
                    if (PreviewManager.this.trackedEditors.containsKey(source)) {
                        IEditorPart editorPart = (IEditorPart)source;
                        try {
                            PreviewManager.this.openPreview(editorPart, editorPart.getEditorInput(), null, false);
                        }
                        catch (CoreException e) {
                            PreviewPlugin.log(e);
                        }
                    } else {
                        IEditorInput editorInput = ((IEditorPart)source).getEditorInput();
                        if (editorInput instanceof IURIEditorInput) {
                            PreviewManager.this.checkLinkedEditor(((IURIEditorInput)editorInput).getURI());
                        }
                    }
                }
            }
        };
    }

    public static PreviewManager getInstance() {
        if (instance == null) {
            instance = new PreviewManager();
        }
        return instance;
    }

    public void init() {
        IWorkbenchWindow[] windows;
        this.addPartListener();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editor = iEditorReferenceArray[n6];
                    IEditorPart editorPart = editor.getEditor(false);
                    if (editorPart != null) {
                        editorPart.addPropertyListener(this.editorPropertyListener);
                        IEditorInput editorInput = editorPart.getEditorInput();
                        if (editorInput instanceof IURIEditorInput) {
                            this.trackedURIs.add(((IURIEditorInput)editorInput).getURI());
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void dispose() {
        this.removePartListener();
    }

    public void openPreviewForEditor(final IEditorPart editorPart) {
        block8: {
            try {
                IDocumentProvider documentProvider;
                IEditorInput editorInput = editorPart.getEditorInput();
                if (!editorPart.isDirty()) {
                    this.openPreview(editorPart, editorInput, null);
                    break block8;
                }
                if (!(editorPart instanceof AbstractTextEditor) || (documentProvider = ((AbstractTextEditor)editorPart).getDocumentProvider()) == null) break block8;
                if (documentProvider.canSaveDocument((Object)editorInput)) {
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    if (document == null) break block8;
                    try {
                        if (!this.openPreview(editorPart, editorInput, document.get())) {
                            final boolean[] openPreview = new boolean[1];
                            UIUtils.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    openPreview[0] = MessageDialog.openQuestion((Shell)editorPart.getSite().getShell(), (String)Messages.PreviewManager_UnsavedPrompt_Title, (String)Messages.PreviewManager_UnsavedPrompt_Message);
                                }
                            });
                            if (openPreview[0]) {
                                this.openPreview(editorPart, editorInput, null);
                            }
                        }
                        break block8;
                    }
                    catch (CoreException e) {
                        PreviewPlugin.log(e);
                    }
                    break block8;
                }
                this.openPreview(editorPart, editorInput, null);
            }
            catch (CoreException e) {
                PreviewPlugin.log(e);
            }
        }
    }

    public void openPreviewForEditorInput(IEditorInput editorInput) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = null;
        if (workbenchWindow != null) {
            workbenchPage = workbenchWindow.getActivePage();
        }
        IEditorPart editorPart = null;
        if (workbenchPage != null) {
            editorPart = workbenchPage.findEditor(editorInput);
        }
        try {
            this.openPreview(editorPart, editorInput, null);
        }
        catch (CoreException e) {
            PreviewPlugin.log(e);
        }
    }

    public boolean testEditorInputForPreview(IEditorInput editorInput) {
        try {
            SourceConfig sourceConfig = this.getSourceConfig(editorInput, null);
            if (sourceConfig != null) {
                PreviewConfig previewConfig;
                IPreviewHandler handler = PreviewHandlers.getInstance().getHandler(sourceConfig.getContentType());
                if (handler == null) {
                    handler = DefaultPreviewHandler.getInstance();
                }
                if ((previewConfig = handler.handle(sourceConfig)) == null && !(handler instanceof DefaultPreviewHandler)) {
                    previewConfig = DefaultPreviewHandler.getInstance().handle(sourceConfig);
                }
                return previewConfig != null;
            }
        }
        catch (CoreException e) {
            PreviewPlugin.log(e);
        }
        return false;
    }

    private boolean openPreview(IEditorPart editorPart, IEditorInput editorInput, String content) throws CoreException {
        return this.openPreview(editorPart, editorInput, content, true);
    }

    /*
     * Unable to fully structure code
     */
    private SourceConfig getSourceConfig(IEditorInput editorInput, String content) throws CoreException {
        fileName = null;
        project = null;
        path = null;
        workspacePath = null;
        if (editorInput instanceof IPathEditorInput) {
            try {
                path = ((IPathEditorInput)editorInput).getPath();
                if (path == null) ** GOTO lbl30
                fileName = path.lastSegment();
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(path.toFile().toURI());
                if (files.length <= 0) ** GOTO lbl30
                project = files[0].getProject();
                workspacePath = files[0].getFullPath();
            }
            catch (Exception e) {
                return null;
            }
        } else if (!(editorInput instanceof IStorageEditorInput)) {
            if (editorInput instanceof IURIEditorInput) {
                fileStore = EFS.getStore((URI)((IURIEditorInput)editorInput).getURI());
                if (fileStore != null && (file = fileStore.toLocalFile(0, null)) != null) {
                    fileName = file.getName();
                    path = Path.fromOSString((String)file.getAbsolutePath());
                    files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
                    if (files.length > 0) {
                        project = files[0].getProject();
                        workspacePath = files[0].getFullPath();
                    }
                }
            } else if (editorInput instanceof PreviewEditorInput) {
                return null;
            }
        }
lbl30:
        // 8 sources

        if (fileName == null) {
            return null;
        }
        contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
        return new SourceConfig(editorInput, project, project != null ? workspacePath : path, content, contentType);
    }

    private boolean openPreview(IEditorPart editorPart, IEditorInput editorInput, String content, boolean forceOpen) throws CoreException {
        SourceConfig sourceConfig = this.getSourceConfig(editorInput, content);
        PreviewConfig previewConfig = null;
        if (sourceConfig != null) {
            IPreviewHandler handler = PreviewHandlers.getInstance().getHandler(sourceConfig.getContentType());
            if (handler == null) {
                handler = DefaultPreviewHandler.getInstance();
            }
            if ((previewConfig = handler.handle(sourceConfig)) == null && !(handler instanceof DefaultPreviewHandler)) {
                previewConfig = DefaultPreviewHandler.getInstance().handle(sourceConfig);
            }
        }
        if (previewConfig != null) {
            this.showEditor(editorPart, sourceConfig, previewConfig, forceOpen);
            return true;
        }
        return false;
    }

    private void showEditor(IEditorPart editorPart, SourceConfig sourceConfig, PreviewConfig previewConfig, boolean forceOpen) throws CoreException {
        PreviewEditorInput previewEditorInput;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = null;
        if (workbenchWindow != null) {
            workbenchPage = workbenchWindow.getActivePage();
        }
        if (workbenchPage == null) {
            throw new PartInitException("Cannot get Workbench page");
        }
        IEditorPart[] openedPreviewEditors = new IEditorPart[]{};
        if (editorPart != null && (previewEditorInput = this.trackedEditors.get(editorPart)) != null) {
            openedPreviewEditors = EditorUtils.findEditors(previewEditorInput, "com.aptana.preview.editor");
        }
        PreviewEditorInput input = new PreviewEditorInput(previewConfig.getURL(), sourceConfig.getEditorInput().getName(), sourceConfig.getEditorInput().getToolTipText());
        if (openedPreviewEditors.length > 0) {
            IEditorPart[] iEditorPartArray = openedPreviewEditors;
            int n = openedPreviewEditors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart previewEditorPart = iEditorPartArray[n2];
                previewEditorPart.getSite().getPage().reuseEditor((IReusableEditor)previewEditorPart, (IEditorInput)input);
                ++n2;
            }
            if (forceOpen) {
                workbenchPage.activate((IWorkbenchPart)openedPreviewEditors[0]);
            }
        } else {
            openedPreviewEditors = EditorUtils.findEditors(input, "com.aptana.preview.editor");
            if (openedPreviewEditors.length > 0) {
                IEditorPart[] iEditorPartArray = openedPreviewEditors;
                int n = openedPreviewEditors.length;
                int n3 = 0;
                while (n3 < n) {
                    IEditorPart previewEditorPart = iEditorPartArray[n3];
                    previewEditorPart.getSite().getPage().reuseEditor((IReusableEditor)previewEditorPart, (IEditorInput)input);
                    ++n3;
                }
                if (forceOpen) {
                    workbenchPage.activate((IWorkbenchPart)openedPreviewEditors[0]);
                }
            } else if (forceOpen) {
                workbenchPage.openEditor((IEditorInput)input, "com.aptana.preview.editor", true, 1);
            }
        }
        if (editorPart != null && !this.trackedEditors.containsKey(editorPart)) {
            editorPart.addPropertyListener(this.editorPropertyListener);
            this.trackedEditors.put(editorPart, input);
            this.addFilewatchListener(editorPart);
        }
    }

    private void checkLinkedEditor(URI uri) {
        IEditorPart editorPart = null;
        for (IEditorPart editor : this.trackedEditors.keySet()) {
            IEditorLinkedResources editorLinkedResources = (IEditorLinkedResources)editor.getAdapter(IEditorLinkedResources.class);
            if (editorLinkedResources == null || !editorLinkedResources.hasReference(uri)) continue;
            editorPart = editor;
            break;
        }
        if (editorPart != null) {
            final IEditorPart finalEditorPart = editorPart;
            UIUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        PreviewManager.this.openPreview(finalEditorPart, finalEditorPart.getEditorInput(), null, false);
                    }
                    catch (CoreException e) {
                        PreviewPlugin.log(e);
                    }
                }
            });
        }
    }

    private void addFilewatchListener(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        String watchPath = null;
        if (editorInput instanceof IFileEditorInput) {
            watchPath = ((IFileEditorInput)editorInput).getFile().getProject().getLocation().toOSString();
        } else if (editorInput instanceof IPathEditorInput) {
            watchPath = ((IPathEditorInput)editorInput).getPath().toFile().getParentFile().getAbsolutePath();
        } else if (editorInput instanceof IURIEditorInput) {
            try {
                File file;
                IFileStore fileStore = EFS.getStore((URI)((IURIEditorInput)editorInput).getURI());
                if (fileStore != null && (file = fileStore.toLocalFile(0, null)) != null) {
                    watchPath = file.getParentFile().getAbsolutePath();
                }
            }
            catch (CoreException e) {
                PreviewPlugin.log(e);
            }
        }
        if (watchPath != null) {
            try {
                int watchId = FileWatcher.addWatch((String)watchPath, (int)15, (boolean)true, (JNotifyListener)new JNotifyAdapter(){

                    public void fileCreated(int wd, String rootPath, String name) {
                        this.fileModified(wd, rootPath, name);
                    }

                    public void fileModified(int wd, String rootPath, String name) {
                        URI fileURI = URIUtil.toURI((IPath)new Path(rootPath).append(name));
                        if (!PreviewManager.this.trackedURIs.contains(fileURI)) {
                            PreviewManager.this.checkLinkedEditor(fileURI);
                        }
                    }
                });
                this.filewatchIds.put(editorPart, watchId);
            }
            catch (JNotifyException e) {
                PreviewPlugin.log(e);
            }
        }
    }

    private void removeFilewatchListener(IEditorPart editorPart) {
        try {
            Integer id = this.filewatchIds.get(editorPart);
            if (id != null) {
                FileWatcher.removeWatch((int)id);
            }
        }
        catch (JNotifyException e) {
            PreviewPlugin.log(e);
        }
        this.filewatchIds.remove(editorPart);
    }

    private void addPartListener() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(this.editorPartListener);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
    }

    private void removePartListener() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(this.editorPartListener);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
    }
}

